/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands.parser;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import moze_intel.projecte.utils.RegistryUtils;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NSSItemParser {
    private static final DynamicCommandExceptionType UNKNOWN_ITEM = new DynamicCommandExceptionType(xva$0 -> PELang.UNKNOWN_ITEM.translate(xva$0));
    private static final DynamicCommandExceptionType UNKNOWN_TAG = new DynamicCommandExceptionType(xva$0 -> PELang.UNKNOWN_TAG.translate(xva$0));
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    private static final char SYNTAX_START_NBT = '{';
    private static final char SYNTAX_TAG = '#';
    private final HolderLookup<Item> items;
    private final StringReader reader;
    private Either<Holder<Item>, ResourceLocation> result;
    @Nullable
    private CompoundTag nbt;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    public NSSItemParser(HolderLookup<Item> items, StringReader readerIn) {
        this.items = items;
        this.reader = readerIn;
    }

    public static NSSItemResult parseResult(HolderLookup<Item> items, StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        try {
            NSSItemParser nssItemParser = new NSSItemParser(items, reader);
            nssItemParser.parse();
            return (NSSItemResult)nssItemParser.result.map(item -> new ItemResult((Holder<Item>)item, nssItemParser.nbt), TagResult::new);
        }
        catch (CommandSyntaxException e) {
            reader.setCursor(cursor);
            throw e;
        }
    }

    public static CompletableFuture<Suggestions> fillSuggestions(HolderLookup<Item> items, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        NSSItemParser parser = new NSSItemParser(items, reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return parser.suggestions.apply(builder.createOffset(reader.getCursor()));
    }

    private void parse() throws CommandSyntaxException {
        this.suggestions = this::suggestTagOrItem;
        int cursor = this.reader.getCursor();
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.reader.expect('#');
            this.suggestions = this::suggestTag;
            ResourceLocation name = ResourceLocation.m_135818_((StringReader)this.reader);
            Optional tag = this.items.m_254901_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)name));
            tag.orElseThrow(() -> {
                this.reader.setCursor(cursor);
                return UNKNOWN_TAG.createWithContext((ImmutableStringReader)this.reader, (Object)name);
            });
            this.result = Either.right((Object)name);
        } else {
            ResourceLocation name = ResourceLocation.m_135818_((StringReader)this.reader);
            Optional item = this.items.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)name));
            this.result = Either.left((Object)((Holder)item.orElseThrow(() -> {
                this.reader.setCursor(cursor);
                return UNKNOWN_ITEM.createWithContext((ImmutableStringReader)this.reader, (Object)name);
            })));
            this.suggestions = this::suggestOpenNbt;
            if (this.reader.canRead() && this.reader.peek() == '{') {
                this.suggestions = SUGGEST_NOTHING;
                this.nbt = new TagParser(this.reader).m_129373_();
            }
        }
    }

    private CompletableFuture<Suggestions> suggestOpenNbt(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('{'));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_205106_(this.items.m_214063_().map(reference -> reference.m_205839_().f_203868_()), (SuggestionsBuilder)builder, (String)String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82957_(this.items.m_214062_().map(reference -> reference.m_205785_().m_135782_()), (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestTagOrItem(SuggestionsBuilder builder) {
        this.suggestTag(builder);
        return this.suggestItem(builder);
    }

    public static NSSItemResult resultOf(ItemStack stack) {
        return new ItemResult(stack.m_41720_(), stack.m_41783_());
    }

    public static interface NSSItemResult {
        public String getStringRepresentation();
    }

    private record ItemResult(Item item, @Nullable CompoundTag nbt) implements NSSItemResult
    {
        public ItemResult(Holder<Item> item, @Nullable CompoundTag nbt) {
            this((Item)item.get(), nbt);
        }

        @Override
        public String getStringRepresentation() {
            String registryName = RegistryUtils.getName(this.item).toString();
            if (this.nbt == null) {
                return registryName;
            }
            return registryName + this.nbt;
        }
    }

    private record TagResult(ResourceLocation tagName) implements NSSItemResult
    {
        @Override
        public String getStringRepresentation() {
            return "#" + this.tagName.toString();
        }
    }
}

